
# testpif.awk,  2 Sep 09

BEGIN {
	total_ifs=0
	num_tests["=="]=1
	num_tests["==2|"]=2
	num_tests["==3|"]=3
	num_tests["==4|"]=4
	num_tests["<>"]=5
	num_tests["><"]=6
	}

NF < 6 {
	next
	}

	{
	total_ifs++
	for (t=6; t <= NF; t++)
	   testpif[num_tests[$t]]++
	next
	}

END {
	print total_ifs
	for (nt=1; nt < 5; nt++)
	   printf("%3d  %5d  %5.2f\n", nt, testpif[nt], \
					(100.0*testpif[nt])/total_ifs)
	printf(" <>  %5d  %5.2f\n", testpif[5], \
					(100.0*testpif[5])/total_ifs)
	printf(" ><  %5d  %5.2f\n", testpif[6], \
					(100.0*testpif[6])/total_ifs)
	}

