
# sortififelse.awk, 26 Sep 09

# ifif else lines will occur before any corresponding ifif lines
# for a given source file.  So we need to merge them into line
# number order, for a given file.

function get_ifif()
{
getline
first_line=$0
new_line_num=$1

getline
second_line=$0
}

function save_else()
{
num_elses++
else_line_num[num_elses]=new_line_num
else_line_num[num_elses+1]=9999999  # a stop condition
else_first[num_elses]=first_line
else_second[num_elses]=second_line
}

function write_else(else_ptr)
{
print "--- ifif else"
print else_first[else_ptr]
print else_second[else_ptr]
}

function reset_else()
{
cur_else=1
else_line_num[cur_else]=9999999  # a stop condition
}

function write_all_else()
{
for (ln=cur_else; ln <= num_elses; ln++)
   write_else(ln)

reset_else()
num_elses=0
}


BEGIN {
	start_state=0
	st_if=1
	st_el=2
	cur_state=start_state
	num_elses=0
	cur_line_num=0
	reset_else()
	}

$1 == "---" {
	pifif_str=$0
	if ($3 == "else")
	   new_state=st_el
	else
	   new_state=st_if
	get_ifif()
	}

#       if            el
# if  < or >      write+save
# el save < or >     save

cur_state == st_if {
	if (new_state == st_el)
	   {
	   write_all_else()
	   save_else()
	   cur_state=new_state
	   next
	   }
	if (new_line_num <= cur_line_num)
	   write_all_else()
	else
	   while (else_line_num[cur_else] < new_line_num)
	      {
	      write_else(cur_else)
	      cur_else++
	      }
	print pifif_str
	print first_line
	print second_line
	cur_line_num=new_line_num
	next
	}

cur_state == st_el {
	if (new_state == st_el)
	   {
	   save_else()
	   next
	   }
	while (else_line_num[cur_else] < new_line_num)
	   {
	   write_else(cur_else)
	   cur_else++
	   }
	print pifif_str
	print first_line
	print second_line
	cur_line_num=new_line_num
	cur_state=new_state
	next
	}

	{
	if (new_state == st_el)
	   {
	   save_else()
	   }
	else
	   {
	   print pifif_str
	   print first_line
	   print second_line
	   cur_line_num=new_line_num
	   }
	cur_state=new_state
	next
	}

END {
	write_all_else()
	}

