
# sortifif.awk, 17 Sep 09

function has_2_or()
{
for (tok=5; tok < NF; tok++)
   if ($tok == "==2|")
      return 1
return 0
}

function get_ifif()
{
getline
first_line=$0
new_line_num=$1
new_state=eq_eq
if (has_2_or() == 1)
   new_state=or_eq

getline
second_line=$0
if (has_2_or() == 1)
   new_state=eq_or

}

function save_cond()
{
num_conds++
all_first[num_conds]=first_line
all_second[num_conds]=second_line
line_index[new_line_num]=num_conds
}

function write_conds()
{
for (ln=1; ln <= max_line_num; ln++)
   if (line_index[ln] != 0)
      {
      print pifif_str
      print all_first[line_index[ln]]
      print all_second[line_index[ln]]
      }
delete all_first
delete all_second
delete line_index
cur_line_num=0
max_line_num=0
}


BEGIN {
	start_state=0
	eq_eq=1
	or_eq=2
	eq_or=3
	cur_state=start_state
	cur_line_num=0
	max_line_num=0
	}

$1 == "---" {
	pifif_str=$0
	get_ifif()
	}

#       ee            e|         |e
# ee  < or >      write+save    save 
# e| write+save       save      save
# |e write+save   write+save    save

cur_state == or_eq {
	if (new_state == or_eq)
	   save_cond()
	else
	   {
	   write_conds()
	   save_cond()
	   }
	cur_state=new_state
	if (new_state == eq_eq)
	   cur_line_num=new_line_num
	if (new_line_num > max_line_num)
	   max_line_num=new_line_num
	next
	}

cur_state == eq_or {
	if (new_state == eq_or)
	   {
	   write_conds()
	   save_cond()
	   }
	else
	   save_cond()
	cur_state=new_state
	if (new_state == eq_eq)
	   cur_line_num=new_line_num
	if (new_line_num > max_line_num)
	   max_line_num=new_line_num
	next
	}

cur_state == eq_eq {
	if (new_state == or_eq)
	   save_cond()
	else if ((new_state == eq_or) || \
	         (new_line_num < cur_line_num))
	   {
	   write_conds()
	   save_cond()
	   }
	else
	   save_cond()
	if (new_state == eq_eq)
	   cur_line_num=new_line_num
	cur_state=new_state
	if (new_line_num > max_line_num)
	   max_line_num=new_line_num
	next
	}

	{
	save_cond()
	cur_state=new_state
	cur_line_num=new_line_num
	max_line_num=new_line_num
	next
	}
	

END {
	write_conds()
	}

