#
# 27 Aug 09, singleif.awk

function print_func(expr_stmt, dash_str)
{
if (expr_stmt == "")
   return
num_funcs++
print "void f_" num_funcs "(void) {"
sub(/[0-9]+   [0-9]+ /, "& */", expr_stmt)
print "/* " expr_stmt " ; "
print "// " dash_str
print "}"
}


function print_ifelse_lines()
{
for (sl=1; sl <= num_seqs; sl++)
   print_func(ifelse_line[sl], ifelse_dash[sl])
delete ifelse_line
delete ifelse_ref
num_seqs=0
}

BEGIN {
	wrong_compare["&&"]=1
	wrong_compare["!="]=1
	wrong_compare[">="]=1
	wrong_compare["<="]=1
	wrong_compare[">"]=1
	wrong_compare["<"]=1
	num_seqs=0
	cur_line_num=0
	in_else=0
	}

$1 == "---" && $2 == "ifelse" {
	dashdash=$0
	cur_is_else=($3 == "else")
	getline
	if (($1 < cur_line_num) && \
		((cur_is_else == 1) || (cur_is_else == in_else)))
	   print_ifelse_lines()
	in_else=cur_is_else
	cur_line_num=$1
	if (NF < 4)
	   next
	for (tok=4; tok <= NF; tok++)
	   if (wrong_compare[$tok] == 1)
	      next
	seen_eq=0
	for (tok=4; tok <= NF; tok++)
	   if ($tok == "==")
	      seen_eq=1
	if (seen_eq == 0)
	   next
	num_seqs++
	ifelse_ref[$1]=num_seqs
	ifelse_line[num_seqs]=$0
	ifelse_dash[num_seqs]=dashdash
	next
	}

# ifelseif matches occur when there is no else present
# A match will also have occurred on the ifelseifelse pattern
# when no else is present
$1 == "---" && $2 == "ifelseif" {
	getline
	getline
	next
	}

$1 == "---" {
	in_else=0
	next
	}

# Must be a ifelseifelse line
	{
	ifelse_line[ifelse_ref[$1]]=""	
	next
	}

END {
	print_ifelse_lines()
	}

