#
# rmpartialseq.awk, 30 Sep 09

function print_seq()
{
print "---"
for (s=1; s <= lines_seen; s++)
   print lines[s]

seq_len[lines_seen]++
if (thenelse[line_num_seen+1] == seen_then)
   then_seq[lines_seen]++
else
   else_seq[lines_seen]++
lines_seen=0
}


BEGIN {
	line_num_seen=0
	in_src=1
	lines_seen=0
	num_partials=0
	seen_then=1
	seen_else=2
	}

# This thenelse information is also used to weed out partial matches
# within sequences of if-else-if, eg, a sequence of two conditions within
# a sequence of three or more conditions.
$2 == "then" {
	line_count++
	thenelse[line_count]=seen_then
	next
	}

$2 == "else" {
	line_count++
	thenelse[line_count]=seen_else
	next
	}

$1 == "/*" {
	line_count++
	line_num[line_count]=$2
	next
	}

$0 == "---" {
	in_src=0
# Only output a sequence if it is the end of a full sequence.
# This is true if the last line was followed by a then/else comment
# in the original processed file.
	if (thenelse[line_num_seen+1] == "")
	   {
	   lines_seen=0
	   num_partials++
	   next
	   }
	if (lines_seen == 0)
	   next
	print_seq()
	t_e_cnt[thenelse[line_num_seen+1]]++
	next
	}

in_src == 1 {
	line_count++
	next
	}

$1 == "|||" {
	other_lines_seen=1
	other_lines[other_lines_seen]=$0
	next
	}

$1 == "//" {
	other_lines_seen++
	other_lines[other_lines_seen]=$0
	next
	}

	{
	lines_seen++
	line_num_seen=$1
	new_line=$1 " " $2 " " $3 " " line_num[$1]
	for (c=4; c <= NF; c++)
	   new_line=new_line " " $c
	lines[lines_seen]=new_line
	next
	}

END {
	print_seq()
	for (li=1; li <= other_lines_seen; li++)
	   print other_lines[li]
	print "start_if_seq_summary"
	for (s=0; s < 20; s++)
	   printf("%5d  %5d  %5.2f  %5.2f\n", s, seq_len[s], \
				(100.0*then_seq[s])/(0.001+seq_len[s]), \
				(100.0*else_seq[s])/(0.001+seq_len[s]))
	print "end_if_seq_summary"
	}

