
# mergecase.awk,  3 Oct 09

function get_sw_expr()
{
expr=$4
for (ot=5; ot <= NF; ot++)
   expr=expr " " $ot

return expr
}

function print_other()
{
if (cur_other_offset >= num_others)
   return
in_switch=0
cur_other_start=sw_other_start[cur_other_offset]
while ((cur_other_start == sw_other_start[cur_other_offset]) &&  \
							(cur_num_others != 0))
   {
   printf("%s %s %s   %s\n", sw_start[cur_other_offset], \
	sw_other_start[cur_other_offset], sw_other_end[cur_other_offset], \
	sw_expr[cur_other_offset])
   cur_other_offset++
   cur_num_others--
   }
}

function print_all_cur_other()
{
if (cur_other_offset >= num_others)
   return
in_switch=0
cur_sw_start=sw_start[cur_other_offset]
while ((cur_sw_start == sw_start[cur_other_offset]) && (cur_num_others != 0))
   {
   printf("%s %s %s   %s\n", sw_start[cur_other_offset], \
	sw_other_start[cur_other_offset], sw_other_end[cur_other_offset], \
	sw_expr[cur_other_offset])
   cur_other_offset++
   cur_num_others--
   }
}

function chk_insertion()
{
if (sw_other_start[cur_other_offset] < $2)
   print_other()
else if (sw_other_start[cur_other_offset] == $2)
   print_other()
}


function start_sw_chk()
{
if ((cur_num_others != 0) && (sw_start[cur_other_offset] == $1))
   {
   cur_sw_expr=get_sw_expr()
   if (sw_expr[cur_other_offset] != cur_sw_expr)
      print "Expected: " sw_expr[cur_other_offset] " saw: " cur_sw_expr
   in_switch=1
   chk_insertion()
   }
}

BEGIN {
	num_others=0
	cur_num_others=0
	cur_other_offset=1
	in_switch=0
	num_start=0
	in_others=1
	}

# The casedist pattern is more likely to have timed out,
# so we need to resyncronise cur_other_offset at the start of a new file
$1 == "Start" {
	if ((in_others == 1) && ($2 == "casedist"))
	   {
	   in_others=0
	   num_start=0
	   }
# Do we have any others left at the end of the file?
	if ((in_others == 0) && \
	    (in_switch == 1)  && (sw_start[cur_other_offset] == prev_start))
	   print_all_cur_other()
	in_switch=0
	num_start++
	prev_others=cur_other_offset
	if ($2 == "casedist")
	   {
	   cur_other_offset=other_start_offset[num_start]+1
	   cur_num_others=other_start_count[num_start]
	   }
	else
	   {
	   other_start_offset[num_start]=num_others
# Need to remember if the number of others is non-zero because we
# only check matches in this case
	   other_start_count[num_start-1]=cur_num_others
	   cur_num_others=0
	   }
	if (in_others == 0)
   	   {
	   print $0
	   if (cur_other_offset < prev_others)
	      print ">> " cur_other_offset " " prev_others
	   unmatched_others+=(cur_other_offset-prev_others)
	   }
	next
	}

$1 == "---" {
	getline
	num_others++
	cur_num_others++
	sw_start[num_others]=$1
	sw_other_start[num_others]=$2
	sw_other_end[num_others]=$3
	sw_expr[num_others]=get_sw_expr()
	next
	}

in_switch == 1 {
	prev_start=sw_start[cur_other_offset]
	if (sw_start[cur_other_offset] != $1)
	   {
	   print_all_cur_other()
	   start_sw_chk()
	   }
	else
	   chk_insertion()
	print $0
	next
	}

	{
	start_sw_chk()
	print $0
	next
	}

END {
	print_other()
	print "// " num_others " " unmatched_others
	}

