#
#  2 Oct 09  joinifif.awk

function print_c(line_str)
{
num_matches++
num_tokens=split(line_str, tokens)
printf("/* %s  %s */  ", tokens[1], tokens[2])
for (t=3; t <= num_tokens; t++)
   printf(" %s", tokens[t])
printf("   ;\n")
}

function print_end_seq()
{
if (last_line != "")
   {
   print_c(last_line)
   match_count[num_matches]++
   if (prev_was_else)
      {
      print "// else"
      else_count[num_matches]++
      }
   else
      {
      print "// then"
      then_count[num_matches]++
      }
   print "}"
   }
last_line=""
}


function print_start_seq(first_line)
{
num_seqs++
print_end_seq()
num_matches=0
printf("void _func%d(void) {\n", num_seqs)
print "// " cur_hdr
print_c(first_line)
}

BEGIN {
	new_match=0
	last_line=""
	num_matches=0
	num_seqs=0
	cur_is_else=0
	}

$1 == "---" {
	prev_was_else=cur_is_else
	cur_hdr=$0
	new_match=1
	cur_is_else=($3 == "else")
	next
	}

new_match == 1 {
	if ($0 != last_line)
	   {
	   if ($NF == "NULL")
	      print_start_seq($1 " " $2 " N_U_L_L_replacement")
	   else
	      print_start_seq($0)
	   }
	else
	   print_c(last_line)
	new_match=0
	next
	}

	{
	if ($NF == "NULL")
	   last_line=$1 " " $2 " N_U_L_L_replacement"
	else
	   last_line=$0
	next
	}

END {
	print_end_seq()
	print "//     total   then   else"
	for (m=1; m < 20; m++)
	   printf("// %2d  %5d  %5.2f  %5.2f\n", m, match_count[m], \
			(100.0*then_count[m])/(0.01+match_count[m]), \
			(100.0*else_count[m])/(0.01+match_count[m]))
#        system("rm " Temp_file)
	}

