#
# 27 Aug 09  joinif.awk

function print_c(line_str)
{
num_tokens=split(line_str, tokens)
printf("/* %s  %s */  ", tokens[1], tokens[2])
for (t=3; t <= num_tokens; t++)
   printf(" %s", tokens[t])
printf("   ;\n")
}

function then_else()
{
if (ifelseif[last_line])
   {
   print "// then"
   then_count[num_matches]++
   }
else
   {
   print "// else"
   else_count[num_matches]++
   }
}


function print_ifelse_cond()
{
printf("") > Temp_file
for (li in ifelse_cond)
   if (ifelse_cond[li] != "")
      {
      sub(/ [0-9]+ /, "& */", ifelse_cond[li])
      print "/* " ifelse_cond[li] " ;" >> Temp_file
      match_count[1]++
      }
close(Temp_file)
num_seqs++
if (last_line != "")
   print "}"
last_line=""
printf("void _func%d(void) {\n", num_seqs)
print "// " ifelse
system("sort -g -k 2 < " Temp_file)
print "}"

delete ifelse_cond
}

BEGIN {
	Temp_file="ie." systime()
	last_line=""
	num_matches=0
	num_seqs=0
	cur_ifelse_line=0
	seen_ifelseif=0
	ifelse_cond[1]="" # dummy assignment
	}

$1 == "---" && $2 == "ifelse" {
	getline
#	if (($1 < cur_ifelse_line) || seen_ifelseif)
#	   print_ifelse_cond()
	cur_ifelse_line=$1
	ifelse_cond[$1]=$0
	seen_ifelseif=0
	if (seen_ifelseif)
	   {
	   delete ifelseif
	   seen_ifelseif=0
	   }
	next
	}

# ifelseif matches occur when there is no else present
# A match will also have occurred on the ifelseifelse pattern
# when no else is present
$1 == "---" && $2 == "ifelseif" {
	getline
	getline
	ifelseif[$0]=1
	seen_ifelseif=1
	next
	}

$1 == "---" {
	seen_ifelseif=1
	new_match=1
	next
	}

new_match == 1 {
	ifelse_cond[$1]=""
	num_matches++
	print_c(last_line)
	if (last_line != $0)
	   {
	   if (last_line != "")
	      {
	      then_else()
	      print "}"
	      }
	   num_seqs++
	   match_count[num_matches]++
	   num_matches=1
	   printf("void _func%d(void) {\n", num_seqs)
	   print_c($0)
	   } 
	new_match=0
	next
	}

	{
	last_line=$0
	next
	}

END {
	print_c(last_line)
	then_else()
	print "}"
	print "//     total   then   else"
	for (m=1; m < 20; m++)
	   printf("// %2d  %5d  %5.2f  %5.2f\n", m, match_count[m], \
			(100.0*then_count[m])/(0.01+match_count[m]), \
			(100.0*else_count[m])/(0.01+match_count[m]))
#        system("rm " Temp_file)
	}

