
# ifseqlen.awk,  4 Oct 09

BEGIN {
	in_seq_cnt=0
	total_seqs=0
	}

$0 == "start_if_seq_summary" {
	in_seq_cnt=1
	next
	}

$0 == "end_if_seq_summary" {
	in_seq_cnt=0
	next
	}

in_seq_cnt == 1{
	seq_cnt[$1]+=$2
	thenseq_cnt[$1]+=$2*$3/100
	elseseq_cnt[$1]+=$2*$4/100
	total_seqs+=$2
	total_num+=$1*$2
	next
	}

	{
	next
	}

END {
# The following number is obtained by counting the number of
# all if statements where an expression is compared for equality
# against a constant (comparisons against NULL are subtracted off).
# These counts are generated by matchsing.sh, around 25% of single
# if-statements have an if-else form.
#
	if (IF == "ifif")
	   elseseq_cnt[1]=0
	else
	   elseseq_cnt[1]=8966
	thenseq_cnt[1]=28730
	seq_cnt[1]=elseseq_cnt[1]+thenseq_cnt[1]
	carry_cnt=0
	for (sc=1; sc < 20; sc++)
	   {
	   printf("%3d  %5d  %5.2f  %5.0f  %5.2f  %5.2f  %5.2f\n", sc, seq_cnt[sc], \
				(100.0*seq_cnt[sc])/total_seqs, \
				(thenseq_cnt[sc]+elseseq_cnt[sc-1]), \
				100.0*(thenseq_cnt[sc]+elseseq_cnt[sc-1])/(seq_cnt[1]+total_seqs), \
				thenseq_cnt[sc]/(seq_cnt[sc]+0.001), \
				elseseq_cnt[sc]/(seq_cnt[sc]+0.001))
	   }

	print total_seqs
	print total_num
	}

