
# iflinedist.awk, 25 Sep 09

BEGIN {
	new_pair=0
	num_pairs=0
	}

$1 == "---" {
	new_pair=1
	next
	}

new_pair == 1 {
	line_num=$4
	new_pair=0
	next
	}

$1 == "//" {
	next
	}

	{
	if ($4 < line_num)
	   {
#	   print  $4 " < " line_num
	   next
	   }
	num_pairs++
	line_dist[$4-line_num]++
	line_num=$4
	next
	}

END {
	for (ln=0; ln < 20; ln++)
	   printf("%3d  %5.2f\n", ln, (100.0*line_dist[ln])/num_pairs)
	printf("-- %3d  %5.2f\n", num_pairs, (100.0*line_dist[0])/num_pairs)
	tail_total=0
	for (ln=20; ln < 200; ln++)
	   tail_total+= (100.0*line_dist[ln])/num_pairs
	printf("%5.2f\n", tail_total)
	}


