
# ififcntstmt.awk,  7 Oct 09

BEGIN {
	in_matched=0
	}

	{
	line_count++
	}

in_matched == 1 {
	if (line_stmt[$1] != 0)
	   {
	   stmt_cnt[line_stmt[$1]]++
	   num_matches++
	   }
	next
	}

$1 == "//" && $2 == "---" {
	line_stmt[line_count+1]=$4
	next
	}

$1 == "//" && $2 == "|||" {
	in_matched=1
	next
	}

END {
	print "start_if_seq_summary"
	for (s=1; s < 6; s++)
	   printf("%3d  %5d  %5.2f\n", s, stmt_cnt[s], \
			(100.0*stmt_cnt[s])/num_matches)
	print "end_if_seq_summary"
	}

