
# filterpifif.awk, 20 Sep 09

function get_ifif_expr()
{
expr=$4
for (e=5; e <= NF; e++)
   expr=expr " " $e

return expr
}

function get_pifif_expr()
{
expr=$1
for (e=4; e <= NF; e++)
   expr=expr " " $e

return expr
}

function cur_seq_matches()
{
return cur_seq_list[cur_seq_pos] == ifif_expr
}

BEGIN {
	new_seq=0
	ifif_seq_num=0
	pifif_seq_num=0
	in_pifif=0
	}

$1 == "---" {
	hdr_str=$0
	if (in_pifif == 1)
	   pifif_seq_num++
	else
	   ifif_seq_num++
	new_seq=1
	next
	}

$1 == "|||" {
	in_pifif=1
	next
	}

new_seq == 1 {
	new_seq=0
	if (in_pifif == 1)
	   {
	   pifif_seq[pifif_seq_num]=get_pifif_expr()
	   pifif_input[pifif_seq_num]=$0
	   }
	else
	   ifif_seq[ifif_seq_num]=get_ifif_expr()
	next
	}

	{
	if (in_pifif == 1)
	   {
	   pifif_seq[pifif_seq_num]=pifif_seq[pifif_seq_num] "@" get_pifif_expr()
	   pifif_input[pifif_seq_num]=pifif_input[pifif_seq_num] "@" $0
	   }
	else
	   ifif_seq[ifif_seq_num]=ifif_seq[ifif_seq_num] "@" get_ifif_expr()
	next
	}

END {
	for (p=1; p <= pifif_seq_num; p++)
	   {
	   for (i=1; i <= ifif_seq_num; i++)
	      {
	      if (pifif_seq[p] == ifif_seq[i])
		 {
		 print hdr_str
		 seq_len=split(pifif_input[p], pifif_array, "@")
		 seq_len_count[seq_len]++
		 for (a=1; a <= seq_len; a++)
		    print pifif_array[a]
		 break
		 }
	      }
	   }
	print "|||"
	for (c=1; c < 20; c++)
	   printf("// %2d %5d\n", c, seq_len_count[c])
	}

