
# swcomplex.awk, 28 Aug 09

function skip_to_close_rnd(start_tok)
{
paren_next=1
for (t=start_tok; t <= NF; t++)
   if ($t == "(")
      paren_next++
   else if ($t == ")")
      {
      paren_next--
      if (paren_next == 0)
	 return t
      }
return start_tok+1

}

function expr_complexity(start_tok)
{
last_was_id=0
unbin_expr_comp=0
real_expr_comp=0
for (t=start_tok; t <= NF; t++)
   {
   if (is_macro[$t] == 1)
      continue
   if ($t == "sizeof")
      {
      if ($(t+1) == "(")
	 t=skip_to_close_rnd(t+2)
      continue
      }
   if (($t == "(") && (is_type[$(t+1)] == 1))
      {
      t=skip_to_close_rnd(t+2)
      continue
      }
# casting to point to ...
   if (($t == "*") && ($(t+1) == ")"))
      {
      t+=2
      continue
      }

   if ($t == "->")
      real_expr_comp++
   else
      {
      unbin_expr_comp += tok_complexity[$t]
      real_expr_comp += tok_complexity[$t]
      }
   if ((last_was_id == 1) && ($t == "("))
      {
      num_funcs++
print $0
      }
   if ($t ~ /^[[:lower:]]+[_A-Za-z0-9]+$/)
      {
      last_was_id=1
      }
   else
      last_was_id=0
   }

}

BEGIN {
#	tok_complexity["->"]=1
	tok_complexity["+"]=1
	tok_complexity["-"]=1
	tok_complexity["*"]=1
	tok_complexity["/"]=1
	tok_complexity["%"]=1
	tok_complexity["|"]=1
	tok_complexity["&"]=1
	tok_complexity["^"]=1
	tok_complexity["~"]=1
	tok_complexity["!"]=1
	tok_complexity["||"]=1
	tok_complexity["&&"]=1
	tok_complexity["++"]=1
	tok_complexity["--"]=1
	is_macro["ffestw_state"]=1
	is_macro["ffestw_stack_top"]=1
	is_macro["ffelab_type"]=1
	is_macro["ffelex_token_type"]=1
	is_macro["ffebld_op"]=1
	is_macro["usb_pipetype"]=1
	is_macro["le16_to_cpu"]=1
	is_macro["nodeTag"]=1
	is_type["char"]=1
	is_type["short"]=1
	is_type["int"]=1
	is_type["long"]=1
	is_type["void"]=1
	last_was_id=0
	switch_offset=0
	num_funcs=0
	num_switchs=0
	in_ifelse=0
	count_next=0
	}

$1 == "---" {
	count_next=1
	in_ifelse=1
	next
	}

count_next == 1 || \
(in_ifelse == 0 && $1 != switch_offset) {
	expr_complexity(TOK_OFF)
	unbin_comp_spread[unbin_expr_comp]++
	real_comp_spread[real_expr_comp]++
	switch_offset=$1
	num_switchs++
	count_next=0
	next
	}

	{
	next
	}

END {
	printf("%5d  %6d  %5.2f\n",  num_funcs, num_switchs, \
				(100.0*num_funcs)/num_switchs)
	for (c=0; c < 6; c++)
	   printf("%3d  %6d  %5.2f\n",  c, unbin_comp_spread[c], \
				(100.0*unbin_comp_spread[c])/num_switchs)
	print "Including ->"
	for (c=0; c < 6; c++)
	   printf("%3d  %6d  %5.2f\n",  c, real_comp_spread[c], \
				(100.0*real_comp_spread[c])/num_switchs)
	}

