
# constexpr.sh,  2 Oct 09

TIMELIMIT="-timeout 300"			; export TIMELIMIT
SPATCH="spatch.opt -no_loops"			; export SPATCH
COCCI="../scripts"				; export COCCI
LTGT="-iso_file $COCCI/ltgt.iso"		; export LTGT
REVEQ="-iso_file $COCCI/eqrev.iso"		; export REVEQ

curdir=`pwd`
LINUX_BASE="linux."`basename $curdir`		; export LINUX_BASE

for f_c in ${LINUX_BASE}[12345678].c
   do
   f=`basename $f_c .c`
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Ceqor.cocci  $REVEQ "$f".c > "$f.eq"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Cbetween.cocci  $LTGT "$f".c > "$f.between"
#   $SPATCH  $TIMELIMIT -sp_file $COCCI/Cor.cocci $REVEQ "$f".c > "$f.or"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Cor.cocci        "$f".c > "$f.or"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Ceqbetween.cocci  $LTGT "$f".c > "$f.eqbetween"

   cat "$f.eq" "$f.eqbetween" > "$f.call"
   done

for f in *.`basename $curdir`
   do
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Ceqor.cocci  $REVEQ "$f.c" > "$f.eq"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Cbetween.cocci  $LTGT "$f.c" > "$f.between"
#   $SPATCH  $TIMELIMIT -sp_file $COCCI/Cor.cocci $REVEQ "$f".c > "$f.or"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Cor.cocci        "$f.c" > "$f.or"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Ceqbetween.cocci  $LTGT "$f.c" > "$f.eqbetween"

   cat "$f.eq" "$f.eqbetween" > "$f.call"
   done

