#
# 27 Aug 09, singleif.awk

function print_func(expr_stmt)
{
if (expr_stmt == "")
   return
num_funcs++
print "void f_" num_funcs "(void) {"
sub(/[0-9]+   [0-9]+ /, "& */", expr_stmt)
print "/* " expr_stmt " ; "
print "// " dashdash
print "}"
}


function print_ifelse_lines()
{
for (sl=1; sl <= num_seqs; sl++)
   print_func(ifelse_line[sl])
delete ifelse_line
delete ifelse_ref
num_seqs=0
}

BEGIN {
	wrong_compare["&&"]=1
	wrong_compare["!="]=1
	wrong_compare[">="]=1
	wrong_compare["<="]=1
	wrong_compare[">"]=1
	wrong_compare["<"]=1
	num_seqs=0
	cur_line_num=0
	}

$1 == "---" && $2 == "ifelse" {
	dashdash=$0
	getline
	if ($1 < cur_line_num)
	   print_ifelse_lines()
	cur_line_num=$1
	if (NF < 4)
	   next
	for (tok=4; tok <= NF; tok++)
	   if (wrong_compare[$tok] == 1)
	      next
	seen_eq=0
	for (tok=4; tok <= NF; tok++)
	   if ($tok == "==")
	      seen_eq=1
	if (seen_eq == 0)
	   next
	num_seqs++
	ifelse_ref[$1]=num_seqs
	ifelse_line[num_seqs]=$0
	next
	}

# ifelseif matches occur when there is no else present
# A match will also have occurred on the ifelseifelse pattern
# when no else is present
$1 == "---" && $2 == "ifelseif" {
	getline
	getline
	next
	}

$1 == "---" {
	next
	}

# Must be a ifelseif line
	{
	ifelse_line[ifelse_ref[$1]]=""	
	next
	}

END {
	print_ifelse_lines()
	}

