
# casepstmt.awk,  3 Oct 09
#
# Count the number of case labels attached to the start of
# a statement sequence.

BEGIN {
	cur_case_start=0
	cur_case_end=0
	num_case=0
	total_cases=0
	total_switchs=0
	num_switch_cases=0
	cur_switch_start=0
	}

$1 == "Start" {
	next
	}

$2 == cur_case_start {
	if ($3 == cur_case_end)
	   num_case++
	next
	}

$3 == cur_case_end {
	cur_case_start=$2
	num_case++
	next
	}

	{
	if ($1 == cur_switch_start)
	   num_switch_cases++
	else
	   {
	   switch_cases[num_switch_cases]++
	   if (num_switch_cases == 1)
	      num_sw_1[num_case]++
	   if (num_switch_cases == 2)
	      num_sw_2[num_case]++
	   num_switch_cases=1
	   cur_switch_start=$1
	   total_switchs++
	   }
	total_case_seqs++
	case_seq_len[num_case]++
	num_case=1
	cur_case_start=$2
	cur_case_end=$3
	next
	}

END {
	case_seq_len[num_case]++
	switch_cases[num_switch_cases]++
	if (INFO == "")
	   {
	   print total_case_seqs
	   print "File: case_seq_len.d"
	   }
	if ((INFO == "") || (INFO == "seq_len"))
	   {
	   for (s=1; s < 20; s++)
	      printf("%3d  %6d  %5.2f\n", s, case_seq_len[s], \
			(100.0*case_seq_len[s])/total_case_seqs)
	   tail_total=0.0
	   for (s=20; s < 200; s++)
	      tail_total+= (100.0*case_seq_len[s])/total_case_seqs
	   print tail_total
	   }
	if (INFO == "")
	   {
	   print total_switchs
	   print "File: case_per_switch.d"
	   }
	if ((INFO == "") || (INFO == "per_switch"))
	   {
	   for (s=1; s < 20; s++)
	      printf("%3d  %6d  %5.2f\n", s, switch_cases[s], \
			(100.0*switch_cases[s])/total_switchs)
	   tail_total=0.0
	   for (s=20; s < 200; s++)
	      tail_total+= (100.0*switch_cases[s])/total_switchs
	   print tail_total
	   }
#	for (s=1; s < 20; s++)
#	   printf("%3d  %6d  %5.2f\n", s, num_sw_1[s], \
#			(100.0*num_sw_1[s])/total_switchs)
#	for (s=1; s < 20; s++)
#	   printf("%3d  %6d  %5.2f\n", s, num_sw_2[s], \
#			(100.0*num_sw_2[s])/total_switchs)
	}

