
# casedist.awk,  3 Oct 09

BEGIN {
	stmt_start_line=0
	stmt_end_line=0
	end_line_set[0]=0
	}

$1 == "Start" {
	next
	}

$1 == "---" {
	cur_stmt_len=$3
	next
	}

$2 == stmt_start_line {
	if ($3 > stmt_end_line)
	   stmt_end_line=$3
	end_line_set[stmt_end_line]=1
	next
	}

end_line_set[$3] == 1 {
	stmt_start_line=$2
	next
	}

	{
	num_seqs++
	if ((stmt_end_line<stmt_start_line) && (INFO == ""))
	   print $0 " " stmt_end_line " " stmt_start_line

	seq_dist[stmt_end_line-stmt_start_line]++
	stmt_len[last_stmt_len]++
	seq_stmt_dist[last_stmt_len*100+stmt_end_line-stmt_start_line]++
	stmt_start_line=$2
	stmt_end_line=$3
	last_stmt_len=cur_stmt_len
	delete end_line_set
	end_line_set[stmt_end_line]=1
	next
	}

END {
	num_seqs++
	seq_dist[stmt_end_line-stmt_start_line]++
	if ((INFO == "") || (INFO == "stmt_len"))
	   {
	   for (s=0; s < 20; s++)
	      printf("%3d  %6d  %5.2f\n", s, seq_dist[s], \
			(100.0*seq_dist[s])/num_seqs)
	   }
	print num_seqs
	if (INFO == "")
	   {
	   tail_total=0.0
	   for (s=20; s < 200; s++)
	      tail_total+= (100.0*seq_dist[s])/num_seqs
	   print tail_total

	   tail_total=0.0
	   for (s=-120; s < 0; s++)
	      tail_total+= (100.0*seq_dist[s])/num_seqs
	   print tail_total
	   print "File: stmt_len"
	   for (s=0; s < 6; s++)
	      printf("%3d  %6d  %5.2f\n", s, stmt_len[s], \
			   (100.0*stmt_len[s])/num_seqs)
	   print ""
	   for (s=0; s < 20; s++)
	      {
	      printf("%3d ", s)
	      for (t=1; t < 6; t++)
	         printf("  %5.2f", (100.0*seq_stmt_dist[t*100+s])/num_seqs)
	      printf("\n")
	      }
	   }
	}

