
# allexpr.sh,  2 Sep 09

TIMELIMIT="-timeout 200"                       ; export TIMELIMIT
SPATCH="spatch.opt" 				; export SPATCH
COCCI="../scripts"				; export COCCI
LTGT="-iso_file $COCCI/ltgt.iso"		; export LTGT
REVEQ="-iso_file $COCCI/eqrev.iso"		; export REVEQ

curdir=`pwd`
LINUX_BASE="linux."`basename $curdir`		; export LINUX_BASE

for f_c in ${LINUX_BASE}[12345678].c
   do
   f=`basename $f_c .c`
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Eeqor.cocci $REVEQ "$f".c > "$f.eeq"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Ebetween.cocci $LTGT "$f".c > "$f.ebetween"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Eor.cocci $REVEQ "$f".c > "$f.eor"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Eeqbetween.cocci $LTGT "$f".c > "$f.eeqbetween"

   cat "$f.eeq" "$f.eeqbetween" > "$f.eall"
   done

for f in *.`basename $curdir`
   do
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Eeqor.cocci $REVEQ "$f.c" > "$f.eeq"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Ebetween.cocci $LTGT "$f.c" > "$f.ebetween"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Eor.cocci $REVEQ "$f.c" > "$f.eor"
   $SPATCH  $TIMELIMIT -sp_file $COCCI/Eeqbetween.cocci $LTGT "$f.c" > "$f.eeqbetween"

   cat "$f.eeq" "$f.eeqbetween" > "$f.eall"
   done

DD=$$.t

for f in *.eall
   do
   sort -g $f | awk -f $COCCI/joincond.awk > $DD
   cat `basename $f .eall`.c $DD | awk -f $COCCI/rmpartialseq.awk > $f.e
   done

rm $DD

