#
# subj-info.awk,  8 Dec 12
# Print out introduction information about subject

BEGIN {
	num_subjects=0
	seen_strategy=1
	seen_start=0
	if_stmt_ans=1
	if_stmt_quest=1
	total_answers=0
	total_experience=0

	print "num_subjects,subj_experience,phone_with_web,paper_or_phone"
	}


function print_subj_ans()
{
printf("%d,%d,%s,%s\n", num_subjects, subj_experience,\
	phone_with_web, paper_or_phone)
}


$1 == "Strategies" {
	if (seen_start != 1)
	   print "Seen " $0 " before seeing a start (i.e., : : )"
	seen_strategy=1
	print_subj_ans()
	next
	}


# Various subject experience values are delimited by :
# This can be used to detect the start of a new subject's answers
($2 == ":") && ($4 == ":") && (NF == 5) {
	if (seen_strategy != 1)
	   print "Strategy missing before start of next subject answers"
	seen_strategy=0
	seen_start=1
	subj_experience=$1
	num_subj_experience+=($1 > 0) # Subjects sometimes forget to give this
	num_subjects++
	phone_with_web=$3
	paper_or_phone=$5
	num_if_prob_seen=0
	num_if_stmt_ans=0
	next
	}

	{
	next
	}

END {
	}

