#
# recall-ans.awk, 10 Dec 12

BEGIN {
	num_subjects=0
	seen_strategy=1
	seen_start=0
	if_stmt_ans=1
	if_stmt_quest=1
	total_answers=0
	total_experience=0

        bitwise[1]="flag"
        bitwise[2]="state"
        bitwise[3]="bits"
        bitwise[4]="options"
        bitwise[5]="status"
        bitwise[6]="mask"
        bitwise[7]="active"
        bitwise[8]="done"
        bitwise[9]="started"
        bitwise[10]="shift"
        bitwise[11]="success"
        bitwise[12]="reset"
        bitwise[13]="0x17"
        bit_max=13

	for (i in bitwise)
	   is_bit[bitwise[i]]=1

        arithmetic[1]="offset"
        arithmetic[2]="rate"
        arithmetic[3]="size"
        arithmetic[4]="length"
        arithmetic[5]="count"
        arithmetic[6]="maximum"
        arithmetic[7]="minimum"
        arithmetic[8]="width"
        arithmetic[9]="index"
        arithmetic[10]="height"
        arithmetic[11]="25"
        arith_max=11

	for (i in arithmetic)
	   is_arith[arithmetic[i]]=1

        anonymous[1]="value"
        anonymous[2]="field"
        anonymous[3]="temp"
        anonymous[4]="i"
        anonymous[5]="data"
        anonymous[6]="current"
        anonymous[7]="id"
        anonymous[8]="buf"
        anon_max=8

        a_op["*"]=1
        a_op["-"]=1
        b_op["&"]=1
        b_op["|"]=1

	print "subject,pat1,pat2,left id1,right id1,operator1,left id2,right id2,operator2"
	}


# Compare operand answer against question operand at
# various positions.
function match_operand(ans_str)
{
match_num=0
for (i=1; i < 5; i++)
   if (ans_str == if_operand[i])
      {
      match_num=i
      break
      }

if (ans_str == "?")
   match_num=5

return match_num
}


function check_operand(ans_str)
{
match_num=match_operand(ans_str)
# An extra s might have been added to the end of the name
# or an s might have been missed off.
# Check for either case.
if (match_num == 0)
   {
   if (ans_str ~ /+*s$/)
      match_num=match_operand(substr(ans_str, 1, length(ans_str)-1))
   else
      match_num=match_operand(ans_str "s")
   }
printf(",%d", match_num)
}


function check_operator(ans_str)
{
match_num=0
# The same operator can occur in both expressions
# Need to order checks so there are not spurious errors flagged
if (if_stmt_ans == 1)
   {
   if (ans_str == if_operator[1])
      match_num=1
   else if (ans_str == if_operator[3])
      match_num=2
   }
else
   {
   if (ans_str == if_operator[3])
      match_num=2
   else if (ans_str == if_operator[1])
      match_num=1
   }
if (ans_str == "?")
   match_num=3

printf(",%d",  match_num)
}


function get_NC_pat(op_str, op_set, left_op, right_op)
{
if (op_set[left_op] == 1)
   expr_pat="C" op_str
else
   expr_pat="N" op_str
if (op_set[right_op] == 1)
   expr_pat=expr_pat "C"
else
   expr_pat=expr_pat "N"
}

function get_expr_pattern(left_op, right_op, op)
{
if_operand[if_stmt_quest]=left_op
if_operand[if_stmt_quest+1]=right_op
if_operator[if_stmt_quest]=op
if (a_op[op] == 1)
   get_NC_pat("a", is_arith, left_op, right_op)
else
   get_NC_pat("b", is_bit, left_op, right_op)
}


$1 == "Strategies" {
	if (seen_start != 1)
	   print "Seen " $0 " before seeing a start (i.e., : : )"
	seen_strategy=1
	next
	}


# Various subject experience values are delimited by :
# This can be used to detect the start of a new subject's answers
($2 == ":") && ($4 == ":") && (NF == 5) {
	if (seen_strategy != 1)
	   print "Strategy missing before start of next subject answers"
	seen_strategy=0
	seen_start=1
	subj_experience=$1
	num_subj_experience+=($1 > 0) # Subjects sometimes forget to give this
	num_subjects++
	phone_with_web=$3
	paper_or_phone=$5
	num_if_prob_seen=0
	num_if_stmt_ans=0
	op_correct=0
	id_correct=0
	id_other_op_correct=0
	id_other_if_correct=0
	id_other_correct=0
	id_wrong=0
	next
	}

# Remember the if statements that subjects saw
# if ( (25 - minimum) == current )
($1 == "if") && ($2 == "(") && (NF == 8) {
	if (seen_strategy == 1)
	   next
	if (if_stmt_quest == 1)
	   printf("%d", num_subjects)
	get_expr_pattern(substr($3, 2), substr($5, 1, length($5)-1), $4)
	printf(",%s", expr_pat)
# Counts for this question
	if_stmt_quest+=2
	num_if_prob_seen++
	next
	}

$2 == "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" {
	if_stmt_ans=1
	if_stmt_quest=1
	next
	}

# Check if statement answers given
# if ( ( id1 ____________  O _  id2 _____________) == id3 )
($1 == "if") && ($2 == "(") && (NF == 12) {
	if (seen_strategy == 1)
	   next
	check_operand($4)
	check_operand($8)
	check_operator($6)
	if (if_stmt_ans == 3)
	   printf("\n")
	if_stmt_ans+=2
	num_if_stmt_ans++
	next
	}

	{
	next
	}

END {
	}

