# genquest.awk, 19 Apr 06
#

function new_page()
{
print ".bp"
if (new_subject == 1)
   {
   new_subject=0
   print ".tl ' '\\s-1%\\s+1'\\s-2accu: apr 06\\s+2'"
   }
else
   {
   print ".tl '" num_subject "_" num_ops "'\\s-1%\\s+1'\\s-2accu: apr 06\\s+2'"
   print num_subject "_" num_ops
   print ".sp 2l"
   print ".tl '" num_subject "_" num_ops "'\\s-1%\\s+1'\\s-2accu: apr 06\\s+2'"
   }
}


function print_line(line_str)
{
print line_str
print ".br"
}

function rand_items(items)
{
for (v in items)
   {
   items[v]=rand() " " items[v]
   }
asort(items)
for (v in items)
   {
   sp_pos=index(items[v], " ")
   items[v]=substr(items[v], sp_pos)
   }
}

function gen_c1()
{
c[1]="4"
c[2]="5"
c[3]="6"
c[4]="8"
c[5]="9"
rand_items(c)
}

function gen_info()
{
id_count++
if (int(id_count % 21) == 0)
   id_count=1

cur_id[1]=id[id_count "1"]
cur_id[2]=id[id_count "2"]
cur_id[3]=id[id_count "3"]
cur_id[4]=id[id_count "4"]
rand_items(cur_id)

gen_c1()

print ".sp 8l"
print_line(cur_id[1] " = " c[1] ";")
print_line(cur_id[2] " = " c[2] ";")
print_line(cur_id[3] " = " c[3] ";")
new_page()
}

function gen_mem_test()
{
print ".sp 12l"
print "\\h'1.2i'     remember  \\h'0.5i' would refer back\\h'0.5i' not seen"
print ".sp 1l"

rand_items(cur_id)
for (v in cur_id)
   {
   print cur_id[v] " = \t____\t__\t__"
   print ".sp 1l"
   }
new_page()
}

function gen_ops(ops, TI, PL, EQ)
{
# Operators in precedence (higher to lower) order.
if (TI == "TI")
   ops[1]="*"
else
   if (TI == "ti")
      ops[1]="/"
   else
      ops[1]="%"

if (PL == "PL")
   ops[2]="+"
else
   ops[2]="-"

ops[3]="<<"
ops[4]="<"

if (EQ == "EQ")
   ops[5]="=="
else
   ops[5]="!="

ops[6]="&"
ops[7]="^"
ops[8]="|"
ops[9]="&&"
ops[10]="||"
}


function rand_ops()
{
# Create an array of every dissimilar operator pair and
# randomise the ordering.
for (f_o in first_op)
   {
   for (s_o in second_op)
      {
      if (first_op[f_o] != second_op[s_o])
         op_pair[first_op[f_o] " " second_op[s_o]]=rand() " " first_op[f_o] "_" second_op[s_o]
      }
   }
asort(op_pair)
for (v in op_pair)
   {
   sp_pos=index(op_pair[v], " ")
   op_pair[v]=substr(op_pair[v], sp_pos)
   }
}


function print_expr(op_1, op_2)
{
print ".sp 2l"
printf("\\h'1i' x  %s   y   %s   z\n", op_1, op_2)
}

function gen_subject(total_quest)
{
expr_per_quest=5
num_quest=0
expr_count=expr_per_quest+1

for (f_o in op_pair)
   {
   if (num_quest == total_quest)
      {
      return
      }
   if (int(expr_count % (expr_per_quest+1)) == 0)
      {
      expr_count=1
      gen_info()
      print ".sp 8l"
      print_line("				XXXXXXXXXXXXXXXXXX")
      print_line("				XXXXXXXXXXXXXXXXXX")
      print_line("				XXXXXXXXXXXXXXXXXX")
      print ".sp 4l"
      }
   expr_count++
   num_ops++
   split(op_pair[f_o], ops, "_")
   print_expr(ops[1], ops[2])
   if (int(expr_count % (expr_per_quest+1)) == 0)
      {
      gen_mem_test()
      num_quest++
      }
   }
}

BEGIN {
	new_subject=1
	num_subject=0
	id_count=0
	print ".pl +11.5i"
	print ".fz +2"
	print ".fam H"
	print ".ta 1.5i 2.9i 4.3i 5.0i"
	print ".ll 7.5i"
	id["1" "1"]="cat";  id["1" "2"]="mat";  id["1" "3"]="hat"; id["1" "4"]="pat"
	id["2" "1"]="hen";  id["2" "2"]="pen";  id["2" "3"]="men"; id["2" "4"]="ben"
	id["3" "1"]="hop";  id["3" "2"]="pop";  id["3" "3"]="top"; id["3" "4"]="mop"
	id["4" "1"]="din";  id["4" "2"]="pin";  id["4" "3"]="sin"; id["4" "4"]="kin"
	id["5" "1"]="cub";  id["5" "2"]="rub";  id["5" "3"]="tub"; id["5" "4"]="hub"

	id["6" "1"]="dat";  id["6" "2"]="lat";  id["6" "3"]="wat"; id["6" "4"]="gat"
	id["7" "1"]="gen";  id["7" "2"]="ren";  id["7" "3"]="sen"; id["7" "4"]="cen"
	id["8" "1"]="dop";  id["8" "2"]="gop";  id["8" "3"]="vop"; id["8" "4"]="rop"
	id["9" "1"]="nin";  id["9" "2"]="rin";  id["9" "3"]="zin"; id["9" "4"]="cin"
	id["10" "1"]="fub";  id["10" "2"]="lub";  id["10" "3"]="wub"; id["10" "4"]="cub"

	id["11" "1"]="dip";  id["11" "2"]="dog";  id["11" "3"]="dad"; id["11" "4"]="den"
	id["12" "1"]="lot";  id["12" "2"]="lip";  id["12" "3"]="led"; id["12" "4"]="lap"
	id["13" "1"]="pin";  id["13" "2"]="pat";  id["13" "3"]="pod"; id["13" "4"]="peg"
	id["14" "1"]="sat";  id["14" "2"]="sir";  id["14" "3"]="sum"; id["14" "4"]="sow"
	id["15" "1"]="wad";  id["15" "2"]="wit";  id["15" "3"]="won"; id["15" "4"]="web"

	id["16" "1"]="fot";  id["16" "2"]="fis";  id["16" "3"]="fum"; id["16" "4"]="fep"
	id["17" "1"]="kam";  id["17" "2"]="kig";  id["17" "3"]="kus"; id["17" "4"]="kod"
	id["18" "1"]="ras";  id["18" "2"]="rit";  id["18" "3"]="ruc"; id["18" "4"]="roz"
	id["19" "1"]="tid";  id["19" "2"]="tor";  id["19" "3"]="tep"; id["19" "4"]="tul"
	id["20" "1"]="vib";  id["20" "2"]="vom";  id["20" "3"]="vup"; id["20" "4"]="vek"
        print ".pl +11.5i"
	print ".fz +2"
	print ".fam H"
	print ".ta 1.5i 2.9i 4.3i 5.0i"
	print ".ll 7.5i"
	print ".tl ' '\\s-1%\\s+1'\\s-2accu: apr 06\\s+2'"
	}

$0 == "" {
	next
	}

# The six input fields are in two sets of three
# TI PL EQ TI PL EQ
# Upper case for the specified operator, lowercase for the alternative
	{
	num_subject++
        num_ops=0
	gen_ops(first_op, $1, $2, $3)
	gen_ops(second_op, $4, $5, $6)
	rand_ops()
	gen_subject(18)
	asort(op_pair)
        gen_subject(18)
	asort(op_pair)
        gen_subject(4)
	delete op_pair
	next
	}

END {
	}

