                    /* memifperm.c,  6 Oct 04 */

/*
 *  6 Oct 04 Fixed awk script interface (now use c1/c2 not e1/e2)
 *  2 Apr 04 Version used for ACCU experiment
 */

#include <stdio.h>
#include <stdlib.h>

#define MAX_MEM_IND (24*4)
#define MAX_IF_IND 8

/*
 * The 24 ways of creating a list of four items
 * from four things.
 */
char *mem_str[MAX_MEM_IND] =
	{
	"v1 c1", "v1 c2", "v3 c1", "v3 c2",
	"v1 c1", "v1 c2", "v3 c2", "v3 c1",
	"v1 c1", "v3 c1", "v1 c2", "v3 c2",
	"v1 c1", "v3 c1", "v3 c2", "v1 c2",
	"v1 c1", "v3 c2", "v3 c1", "v1 c2",
	"v1 c1", "v3 c2", "v1 c2", "v3 c1",
	"v1 c2", "v1 c1", "v3 c1", "v3 c2",
	"v1 c2", "v1 c1", "v3 c2", "v3 c1",
	"v1 c2", "v3 c1", "v1 c1", "v3 c2",
	"v1 c2", "v3 c1", "v3 c2", "v1 c1",
	"v1 c2", "v3 c2", "v3 c1", "v1 c1",
	"v1 c2", "v3 c2", "v1 c1", "v3 c1",
	"v3 c1", "v1 c2", "v1 c1", "v3 c2",
	"v3 c1", "v1 c2", "v3 c2", "v1 c1",
	"v3 c1", "v1 c1", "v1 c2", "v3 c2",
	"v3 c1", "v1 c1", "v3 c2", "v1 c2",
	"v3 c1", "v3 c2", "v1 c1", "v1 c2",
	"v3 c1", "v3 c2", "v1 c2", "v1 c1",
	"v3 c2", "v1 c1", "v3 c1", "v1 c2",
	"v3 c2", "v1 c1", "v1 c2", "v3 c1",
	"v3 c2", "v3 c1", "v1 c1", "v1 c2",
	"v3 c2", "v3 c1", "v1 c2", "v1 c1",
	"v3 c2", "v1 c2", "v3 c1", "v1 c1",
	"v3 c2", "v1 c2", "v1 c1", "v3 c1",
	};
char *if_str[MAX_IF_IND] =
        {
	"(A > E) && (E > U)",
	"(E < A) && (E > U)",
	"(A > E) && (U < E)",
	"(E < A) && (U < E)",
	"(E > U) && (A > E)",
	"(E > U) && (E < A)",
	"(U < E) && (A > E)",
	"(U < E) && (E < A)",
	};

int main(void)
{
int num_subj,
    num_quest,
    mem_ind = -4,
    if_ind = 0;

for (num_subj=0; num_subj < 40; num_subj++)
   {
   printf("SUBJECT\n");
   mem_ind=(mem_ind+4) % MAX_MEM_IND;
   for (num_quest=0; num_quest < 32; num_quest++)
      {
      printf("%10d | %s | %s\n", rand(),
				mem_str[mem_ind], if_str[if_ind]);
      mem_ind=(mem_ind+1) % MAX_MEM_IND;
      if_ind=(if_ind+1) % MAX_IF_IND;
      }
   }

}
